package org.measureyourgradient;

import javax.help.HelpBroker;
import javax.help.HelpSet;

public class Globals
{
	public static HelpSet hsMainHelpSet = null;
	public static HelpBroker hbMainHelpBroker = null;
	
	// For a 2.1 x 100 mm column
	public static double[][] dDeadVolumeArray = {
		{0.95, 0.21288},
		{0.85, 0.21248},
		{0.75, 0.207942857},
		{0.65, 0.2043},
		{0.55, 0.202},
		{0.45, 0.1995},
		{0.35, 0.2058},
		{0.25, 0.22},
		{0.15, 0.24505},
		{0.05, 0.2997}
	};
	
	public static double[][][] dGradientPrograms = 
	{
		{ // Accela 10 min gradient, 0.4 mL/min
			{2.1, 100, 0.4},
			{0.0, 5.0},
			{10.0, 95.0},
			{20, 95.0}
		},
		{ // Accela 10 min gradient, 0.4 mL/min, 18 solutes
			{2.1, 100, 0.4},
			{0.0, 5.0},
			{10.0, 95.0},
			{20, 95.0}
		},
		{ // Accela 10 min gradient, 0.4 mL/min, B11240
			{2.1, 100, 0.4},
			{0.0, 5.0},
			{10.0, 95.0},
			{20, 95.0}
		},
		{ // Accela 10 min gradient, 0.4 mL/min, B10221
			{2.1, 100, 0.4},
			{0.0, 5.0},
			{10.0, 95.0},
			{20, 95.0}
		},
		{ // Accela 100 uL/min step
			{2.1, 100, 0.1},
			{0.0, 5.0},
			{0.01, 95.0},
			{15, 95.0}
		},	
	};
	
	public static String[] strPredefinedValues = {
		"Accela 10 min gradient from 5% to 95% B, 400 uL/min",
		"Accela 10 min gradient from 5% to 95% B, 400 uL/min, 18 solutes",
		"Accela 10 min gradient from 5% to 95% B, 400 uL/min, B11240",
		"Accela 10 min gradient from 5% to 95% B, 400 uL/min, B10221",
		"Accela step from 5% to 95% B, 100 uL/min"
	};
	
	public static double[][] dPredefinedValues = {
		{ // Accela 10 min gradient, 400 uL/min
			1.496, // N,N-dimethylacetamide
			1.001, // aniline
			1.870, // p-toluidine
			3.153, // N,N-diethylacetamide
			2.102, // N-ethylaniline
			2.638, // 4-t-butylpyridine
			4.234, // N-butylaniline
			5.587, // N-pentylaniline
			6.891, // N-hexylaniline
			6.567, // 4-heptylaniline
			6.264, // N,N-dibutylaniline
			7.305, // 4-octylaniline
			8.083, // 4-nonylaniline
			8.912, // 4-decylaniline
			10.488, // N,N-dihexylaniline
			12.357 // N-dodecylaniline
		},
		{ // Accela 10 min gradient, 400 uL/min, 16 solutes - solvent try 1
			1.415,
			0.96,
			1.738,
			3.092,
			2.031,
			2.496,
			4.567,
			6.077,
			7.426,
			6.82,
			6.749,
			7.628,
			8.467,
			9.336,
			11.144,
			12.609
		},
		{ // Accela 10 min gradient, 400 uL/min, 16 solutes - solvent try 2
			1.304,
			0.9,
			1.688,
			3.102,
			1.93,
			2.516,
			4.244,
			5.608,
			6.901,
			6.537,
			6.275,
			7.275,
			8.042,
			8.851,
			10.417,
			12.205
		},
		{ // Accela 10 min gradient, 400 uL/min, B10221
			0.819,
			1.243,
			4.264,
			5.638,
			6.951,
			12.569,
			2.869,
			2.064,
			6.345,
			10.619,
			6.991,
			7.668,
			8.365,
			9.527,
			10.528,
			11.467,
			12.751,
			14.68
		},
		{ // Accela 100 uL/min step
			3.264, // Aniline
			3.991, // N-Methylaniline
			5.588, // N-Butylaniline
			6.588, // N-Pentylaniline
			7.659, // N-Hexylaniline
			19.147, // N-Dodecylaniline
			4.365, // N,N-diethylacetamide
			4.113, // 4-t-butylpyridine
			6.749, // N,N-Dibutylaniline
			13.872, //N,N-Dihexylaniline
			3.182, // Phthalate-C2
			3.627, // Phthalate-C3a
			3.799, // Phthalate-C3
			4.637, // Phthalate-C4
			5.809, // Phthalate-C5
			7.426, // Phthalate-C6
			14.227, // Phthalate-C7
			18.696, // Phthalate-C8
		}
	};

	public static String[] StationaryPhaseArray = {
		"Agilent Eclipse Plus C18 (3.5 \u00b5m particle size)"
	};
	
	public static String[] CompoundNameArray = {
		"N,N-dimethylacetamide",
		"aniline",
		"p-toluidine",
		"N,N-diethylacetamide",
		"N-ethylaniline",
		"4-t-butylpyridine",
		"N-butylaniline",
		"N-pentylaniline",
		"N-hexylaniline",
		"4-heptylaniline",
		"N,N-dibutylaniline",
		"4-octylaniline",
		"4-nonylaniline",
		"4-decylaniline",
		"N,N-dihexylaniline",
		"N-dodecylaniline"
	};
	
	public static double[] CompoundMZArray = {
		88,
		94,
		108,
		116,
		122,
		136,
		150,
		164,
		178,
		192,
		206,
		206,
		220,
		234,
		262,
		262
	};
	
	public static double[][][] StandardIsocraticDataArray = {
		{{0.75, -1.282228455}, {0.65, -1.471419276}, {0.55, -1.090507521}, {0.45, -0.839045057}, {0.35, -0.709219317}, {0.25, -0.727525465}, {0.15, -0.615833984}, {0.05, -0.038460935}}, 
		{{0.95, -1.692651115}, {0.55, -1.323080136}, {0.45, -1.042264325}, {0.35, -0.869400575}, {0.25, -0.758091456}, {0.15, -0.958695937}, {0.05, -0.538667645}},
		{{0.55, -2.226170123}, {0.45, -1.163222333}, {0.35, -0.709219317}, {0.25, -0.727525465}, {0.15, -0.43816015}, {0.05, 0.212355596}}, 
		{{0.85, -1.183678822}, {0.75, -0.908735715}, {0.65, -0.965876093}, {0.55, -0.661898693}, {0.45, -0.459209665}, {0.35, -0.258832316}, {0.25, 0.020059794}, {0.15, 0.373086191}, {0.05, 1.022986596}},
		{{0.95, -1.475654868}, {0.85, -1.31363836}, {0.75, -1.146008708}, {0.65, -1.289079068}, {0.55, -1.123507782}, {0.45, -0.883302393}, {0.35, -0.726858066}, {0.25, -0.585026652}, {0.15, -0.282893798}, {0.05, 0.402925164}},
		{{0.45, -0.971563297}, {0.35, -0.709219317}, {0.25, -0.555671259}, {0.15, -0.016803005}, {0.05, 0.773513617}}, 
		{{0.95, -0.436485918}, {0.85, -0.313975153}, {0.75, -0.19718211}, {0.65, -0.120216949}, {0.55, 0.003426404}, {0.45, 0.151690047}, {0.35, 0.318606796}, {0.25, 0.554544221}, {0.15, 0.85073259}, {0.05, 1.530510352}},
		{{0.95, -0.295032925}, {0.85, -0.136650262}, {0.75, 0.001905326}, {0.65, 0.12509814}, {0.55, 0.281685748}, {0.45, 0.467732324}, {0.35, 0.703504443}, {0.25, 1.011147361}, {0.15, 1.376067317}},
		{{0.95, -0.162831169}, {0.85, 0.021220444}, {0.75, 0.191604123}, {0.65, 0.350691925}, {0.55, 0.541480383}, {0.45, 0.776224039}, {0.35, 1.07533056}, {0.25, 1.474189766}, {0.15, 1.914980469}},
		{{0.95, -0.217141344}, {0.85, -0.174052123}, {0.75, -0.095599204}, {0.65, 0.033927349}, {0.55, 0.267984471}, {0.45, 0.627273431}, {0.35, 1.174004114}, {0.25, 1.951725975}},
		{{0.95, -0.05139740234}, {0.85, -0.09912308772}, {0.75, 0.01822972465}, {0.65, 0.13518014763}, {0.55, 0.32078360919}, {0.45, 0.5820690616}, {0.35, 0.92344442328}, {0.25, 1.3507412546}, {0.15, 1.8362962132}}, 
		{{0.95, -0.085792241}, {0.85, -0.004437485}, {0.75, 0.10111439}, {0.65, 0.254752562}, {0.55, 0.510226379}, {0.45, 0.901918316}, {0.35, 1.51019837}},
		{{0.95, 0.043154712}, {0.85, 0.158857296}, {0.75, 0.288068635}, {0.65, 0.465342081}, {0.55, 0.744951035}, {0.45, 1.175394087}, {0.35, 1.847113192}},
		{{0.95, 0.167575947}, {0.85, 0.31328262}, {0.75, 0.469415245}, {0.65, 0.669507566}, {0.55, 0.976045652}, {0.45, 1.448531977}}, 
		{{0.95, 0.4325288296}, {0.85, 0.59691986503}, {0.75, 0.81021515174}, {0.65, 1.04844674717}, {0.55, 1.36755887531}, {0.45, 1.81187389283}}, 
		{{0.95, 0.56502746}, {0.85, 0.933973367}, {0.75, 1.262941885}, {0.65, 1.584363331}, {0.55, 1.97267933}}
	};
}
